package edu.uky.ai.ml.nn;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * A database is simply a collection of training examples on which a neural
 * network can be trained.
 * 
 * @author Stephen G. Ware
 */
public class Database implements Iterable<Example> {

	/** A list of examples */
	private final ArrayList<Example> examples = new ArrayList<>();
	
	/**
	 * Returns the number of examples in this database.
	 * 
	 * @return the numbers of examples
	 */
	public int size() {
		return examples.size();
	}
	
	/**
	 * Adds a new example to the database.
	 * 
	 * @param input the values to assign to the input neurons
	 * @param output the expected values of the output neurons
	 * @param label the class label associated with this example
	 */
	public void addExample(double[] input, double[] output, String label) {
		examples.add(new Example(input, output, label));
	}

	@Override
	public Iterator<Example> iterator() {
		return examples.iterator();
	}
}
